function res = chris_step_inject_browser
% Loads all step-injection protocol, and SHOWS them in a nice way

list = [1002;1003;1004;1005;1006;2001;2002;2003;2004;3001;3002;3003;3004;3005;4001;4002;4003;4004 
    5001;5002;5003;6001;6002;6003;7001;7002;7003;8001;9001;9002;9003;9004;10001;10003;11001;11002 
    11003;11004;11005;11006;12001;12002;12003;12004;13001;13002;13003;14001;14002;14003;14004;14005 
    15001;16001;16002;16003;16004;16005;17001;17002;17003;17004;17005;18001;18002;18003;18004;18005 
    18006;19001;19002;19003;19004;20001;20002;20003;20004;21001;21002;22001;22002;22003;23001;23002
    23003;23004;23005;24001;24002;24003;24004;24005;24006;25001;25002;25003;25004;25005;25006;26003
    27002;27003;27005;28001;28002;28003;29002;29003;29004;29005;29007;30001;30002;30003;31001;31002
    31003;31004;31005;31006;32001;32002;32003;32004;32005;33001;33002;33003;34001;34002;34003;34004
    34005;35001;35002;36001;36002;36003;37001;37002;37003];   % Full list of cells.

s = [-0.900429	0.459353
-0.911176	-1.016574
0.268672	-0.391535
-0.296773	-0.70612
0.170661	-0.731682
-0.528193	0.037284
-1.116013	-0.757099
-0.575625	-0.708581
-0.957489	1.220039
-1.046835	0.27893
-0.290358	0.514067
0.154505	-0.183203
0.291462	0.35012
-0.425361	0.755845
0.305767	-0.728164
-0.581471	0.485087
0.224141	-1.61923
-0.273388	0.222618
0.169623	-0.587012
0.416861	-0.789049
0.695501	-0.179835
0.443394	0.843686
0.583356	-0.478076
1.612522	0.754815
1.938574	1.409715
0.569827	-0.781718
0.054413	-0.17085
0.580685	2.024551
0.184256	-0.609145
-0.554477	-1.520606
1.131526	-0.58603
0.419914	-0.074714
-0.054012	-1.792739
0.616641	-0.617594
0.976366	0.128216
0.758035	-0.44802
-0.019237	-0.289845
0.875068	-1.091721
1.654259	-0.434805
1.561523	-0.029763
0.36347	-1.044082
0.766437	-0.533754
0.248747	-1.190521
0.472882	-1.377008
-0.269347	-1.006373
1.120225	-0.114276
0.172034	-0.157432
1.901711	-0.180478
1.661505	-0.394175
1.059399	0.205771
1.012039	-1.058422
1.25031	-0.343397
1.989873	0.616066
0.765055	-0.082356
1.205781	0.12038
1.398122	-0.836904
-0.771563	-0.545435
0.167452	-0.545839
0.927865	-0.549676
0.875074	-0.503526
-0.566143	-1.391025
0.078509	-1.085298
0.061171	-0.510558
2.256457	1.075896
0.109425	0.782771
1.283508	-0.561413
1.639286	0.086705
1.927746	0.518364
0.550156	-0.546491
-0.920632	0.641566
0.058185	0.128932
-0.338793	-0.634573
0.142482	-1.392494
-0.1026	-0.245334
0.885744	-0.017577
0.342048	0.013837
-0.355507	-0.355647
-0.145801	-0.400551
-0.111422	1.144401
0.345705	0.659597
-0.574042	-0.182139
0.983986	2.126604
-0.391535	-0.157073
0.617916	-0.573816
-0.584064	0.18303
0.28413	0.32443
-0.843409	-0.972456
-1.934274	-0.91473
-0.017569	0.080741
-0.34739	-0.891812
-0.822225	-0.023352
-0.206583	-0.573633
-0.880125	-0.404601
0.984094	1.151705
-1.321467	-2.226228
0.613326	-0.396984
0.473227	2.225407
1.012284	-0.124168
-0.551622	-1.565101
0.55849	3.495605
-0.960175	0.044004
0.242253	1.077547
-1.549201	0.082078
-1.458326	0.512451
-0.711759	0.343158
-1.086611	-0.154074
-0.8685	-1.281685
-0.905278	0.130237
0.511468	1.272461
-1.023124	1.739555
-0.476601	0.124041
-0.786297	0.861993
-1.246509	0.273285
-1.271084	1.333569
-0.526138	1.817385
-0.480314	0.03375
-0.41578	0.396322
-0.073627	-0.534598
-0.519702	-0.043022
-0.763961	0.361493
-0.563518	0.788905
-0.4351	0.689681
-0.175239	-0.304783
-0.428451	0.249603
-1.360158	0.274992
-0.593016	1.163753
-1.320131	-0.030408
-0.69294	1.331877
-1.157978	0.488067
-0.265129	0.583948
-1.362524	0.316545
-0.958766	-0.013351
-0.583098	-0.466791
0.201258	1.550009
0.339743	1.181078
-1.003149	0.988296
-0.474567	0.821867
-0.871068	0.204067
-0.693698	-0.346374
-0.53228	1.03352
-1.337383	-0.026162
]; % Scores

age = [48;48;48;48;48;48;48;48;48;46;46;46;46;46;48;48;48;48;49;49;49;47;47;47;49;49;49;49;48;48;48;48;49;49;47;47;47;47;47;47;47;47;47;47;45;45;45;46;46;46;46;46;46;45
    45;45;45;45;46;46;46;46;46;47;47;47;47;47;47;45;45;45;45;47;47;47;47;45;45;45;45;45;45;45;45;45;45;45;45;45;45;45;45;48;48;48;48;48;48;49;49;49;49;49;49;49;49;49;49
    49;49;46;46;46;43;43;43;43;43;43;46;46;46;46;46;46;46;46;44;44;44;44;44;46;46;45;45;45;46;46;46];

directory = 'C:\_Data\Chris Data\IC Step\';

% Colors. Forming a kind of a gradient from green, through red, to black
%          43       44      45      46          47      48      49
myColor = [0 1 0; 0 0.5 0.5;0 0 1;  0.5 0 0.5;  1 0 0;  0.5 0 0;0 0 0];

xn = 50000;  % points to consider. Make ridiculously big to see full track.

iCounter = 1;
for(q=1:length(list))
    fileName = sprintf('%d-%d',floor(list(q)/1000), list(q)-1000*floor(list(q)/1000));
    oops = 0;
    try
        a = abfload([directory fileName '.abf']);
    catch
        oops = 1;
    end
    if(~oops)
        b = squeeze(a(:,1,:));  % 2nd channel contains current, while 1st is our voltage (spikes).
        %mySet = [2 4 6];     % We have 10 sweeps in total, so [1 4 7 10] is a good uniform sampling.
        mySet = 1:10;
        mySet(mySet>size(b,2)) = [];    % But if this file is shorter - let it be so.
        data{iCounter} = b(1:min(xn,size(b,1)),mySet);    % Save a new set of tracks.
        cellId(iCounter) = q;    % Group
        iCounter = iCounter+1;
    end
end

g = age(cellId)>0;  % Good cells (all are good by default)
% g = age>=47;

scatterbrowser(s(cellId(g),1),s(cellId(g),2),data(g),list(cellId(g)));

res.xy = [s(cellId(g),1) s(cellId(g),2)];
res.data = data(g);
res.labels = list(cellId(g));

%%%% In case some particular neurons needs to be selected
% my = [9003 11004 9004 2002];  % Selected neurons
% my = [10001 10003];
my = [22001
22002
22003
23001
23003
];
ind = ismember(res.labels,my);
res.xy = res.xy(ind,:);
res.data = res.data(ind);
res.labels = res.labels(ind);

end